<?php

namespace Opencart\Admin\Controller\Extension\productOrderSerialNumber\Module;

class SerialNumber extends \Opencart\System\Engine\Controller
{
	private $error = array();	
	
	public function getOrderProductSerials() {
		$this->load->model('sale/order');
		$order_id = $this->request->get['order_id'];
		$products = $this->model_sale_order->getProducts($order_id);

		$serials = [];

		foreach ($products as $product) {
			$order_product_id = $product['order_product_id'];

			$this->load->model('extension/productOrderSerialNumber/module/serial_number');
			$product_serials = $this->model_extension_productOrderSerialNumber_module_serial_number->getOrderProductSerials($order_product_id);

			$serial_strings = array_map(function($serial) {
				return $serial['serial'];
			}, $product_serials);

			$serials[] = [
				'product_id' => $product['product_id'],
				'order_product_id' => $order_product_id,
				'serials' => implode("</br>", $serial_strings)
			];
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($serials));
	}

	public function getRequirSerial() {

		$product_id = (int)$this->request->get['product_id'];
		
		$require_serial = $this->db->query("SELECT `require_serial` FROM `" . DB_PREFIX . "product` WHERE `product_id` = '" . (int)$product_id . "'");

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode([
			'require_serial' => $require_serial->row['require_serial']
		]));
		
	}

	public function requirSerial() {
		$this->load->language('catalog/product');
		$json = [];

		$product_id = (int)$this->request->post['product_id'];

		$require_serial = (int)$this->request->post['require_serial'];

		if (isset($json['error']) && !isset($json['error']['warning'])) {
			$json['error']['warning'] = $this->language->get('error_warning');
		}

		if (!$json) {
			$this->db->query("UPDATE `" . DB_PREFIX . "product` SET `require_serial` = '" . (int)$require_serial . "' WHERE `product_id` = '" . (int)$product_id . "'");

			$json['success'] = $this->language->get('text_success');
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	public function install(): void
	{
		$query = $this->db->query("SHOW COLUMNS FROM `" . DB_PREFIX . "product` LIKE 'require_serial'");
		if (!$query->num_rows)
			$this->db->query("ALTER TABLE `" . DB_PREFIX . "product` ADD `require_serial` tinyint(1) NOT NULL");

		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "order_product_serial_numbers` (
          `product_serial_id` int(11) NOT NULL AUTO_INCREMENT,
          `order_product_id` int(11) NOT NULL,
          `serial` varchar(255) NOT NULL,
          `found` int(11) NOT NULL DEFAULT '0',
          `date-added` datetime NOT NULL DEFAULT current_timestamp(),
          PRIMARY KEY (`product_serial_id`)
        )");

		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "product_serial_numbers` (
          `product_serial_id` int(11) NOT NULL AUTO_INCREMENT,
          `product_id` int(11) NOT NULL,
          `serial` varchar(255) NOT NULL,
          PRIMARY KEY (`product_serial_id`)
        )");
	}

	private function write($message): void
	{

		fwrite(fopen(DIR_LOGS . 'serials.log', 'a'), date('Y-m-d G:i:s') . ' - ' . print_r($message, true) . "\n");
	}

	public function index(): void
	{

		$this->install();
		$this->load->language('extension/productOrderSerialNumber/module/serial_number');

		$this->document->setTitle($this->language->get('heading_title'));

		$data['breadcrumbs'] = [];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
		];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/productOrderSerialNumber/module/serial_number', 'user_token=' . $this->session->data['user_token'], true)
		];

		$data['save']  = $this->url->link('extension/productOrderSerialNumber/module/serial_number.save', 'user_token=' . $this->session->data['user_token'], true);
		$data['back'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);

		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		$data['module_serial_number_user_group'] = $this->config->get('module_serial_number_user_group');
		$data['module_serial_number_status'] = $this->config->get('module_serial_number_status');
		$data['module_serial_number_order_status'] = $this->config->get('module_serial_number_order_status');
		$data['module_serial_number_auto_order_product_serial'] = $this->config->get('module_serial_number_auto_order_product_serial');
		$data['module_serial_number_mismatch_warning'] = $this->config->get('module_serial_number_mismatch_warning');

		$this->load->model('user/user_group');
		$data['user_groups'] = $this->model_user_user_group->getUserGroups();

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/productOrderSerialNumber/module/serial_number', $data));
	}

	public function save(): void
	{
		$events = $this->db->query("SELECT code FROM " . DB_PREFIX . "event")->rows;
		if (!in_array('add_serial_on_order_confirm', array_column($events, 'code'))) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "event SET code = 'add_serial_on_order_confirm', description = 'Add the serial on the order confirmation.', `trigger` = 'catalog/model/checkout/order.addHistory/after', action = 'extension/productOrderSerialNumber/module/serial_number.addOrderSerial', status = '1', sort_order = '1'");
		}

		if (!in_array('auto_serial_on_order', array_column($events, 'code'))) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "event SET code = 'auto_serial_on_order', description = 'Auto-add the serial on the order confirmation.', `trigger` = 'catalog/model/checkout/order.addHistory/before', action = 'extension/productOrderSerialNumber/module/serial_number.autoOrderSerial', status = '1', sort_order = '1'");
		}

		if ($this->request->post['module_serial_number_status'] == 0) {
			$this->db->query("UPDATE ".DB_PREFIX."event SET status = 0 WHERE code = 'add_serial_on_order_confirm'");
			$this->db->query("UPDATE ".DB_PREFIX."event SET status = 0 WHERE code = 'auto_serial_on_order'");
		} elseif($this->request->post['module_serial_number_status'] == 1) {
			$this->db->query("UPDATE ".DB_PREFIX."event SET status = 1 WHERE code = 'add_serial_on_order_confirm'");
			$this->db->query("UPDATE ".DB_PREFIX."event SET status = 1 WHERE code = 'auto_serial_on_order'");

		}

		$this->load->language('extension/productOrderSerialNumber/module/serial_number');

		$json = [];

		if (!$this->user->hasPermission('modify', 'extension/productOrderSerialNumber/module/serial_number')) {
			$json['error']['warning'] = $this->language->get('error_permission');
		}

		if (!$json) {
			$this->load->model('setting/setting');

			$this->model_setting_setting->editSetting('module_serial_number', $this->request->post);

			$json['success'] = $this->language->get('text_success');
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	public function findOrder(): void
	{

		$this->load->language('extension/productOrderSerialNumber/module/serial_number');

		$this->document->setTitle($this->language->get('heading_title'));

		$data['breadcrumbs'] = [];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('find_order_title'),
			'href' => $this->url->link('extension/productOrderSerialNumber/module/serial_number.findOrder', 'user_token=' . $this->session->data['user_token'], true)
		];

		$data['save']  = $this->url->link('extension/productOrderSerialNumber/module/serial_number.applySerialNumbers', 'user_token=' . $this->session->data['user_token'], true);
		$data['back'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/productOrderSerialNumber/module/serial_find_order', $data));
	}

	public function applySerialNumbers(): void
	{
		$this->load->language('extension/productOrderSerialNumber/module/serial_number');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('extension/productOrderSerialNumber/module/serial_number');

		$data['breadcrumbs'] = [];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/productOrderSerialNumber/module/serial_number.applySerialNumbers&filter_order='.$this->request->get['filter_order'], 'user_token=' . $this->session->data['user_token'], true)
		];

		$order_id = '';

		$data['user_token'] = $this->session->data['user_token'];

		if (isset($this->request->post['filter_order'])) {
			$order_id = $this->request->post['filter_order'];
		}

		if (isset($this->request->get['filter_order'])) {
			$order_id = $this->request->get['filter_order'];
		}

		if ((isset($this->request->post['filter_order']) || isset($this->request->get['filter_order']))) {

			if (isset($this->request->post['filter_order'])) {
				$order_id = $this->request->post['filter_order'];
			} else {
				$order_id = $this->request->get['filter_order'];
			}

			$data['order_id'] = $order_id;

			$products = $this->model_extension_productOrderSerialNumber_module_serial_number->getOrderProducts($order_id);

			foreach ($products as $key => $value) {
				
				$order_product_id = $products[$key]['order_product_id'];

                $products[$key]['serial'] = $this->getProductSerials($order_product_id);

			}

			$data['products'] = $products;
		}

		$data['show_warning'] = $this->config->get('module_serial_number_mismatch_warning');
		
		$data['save']  = $this->url->link('extension/productOrderSerialNumber/module/serial_number.processOrderSerialNumbers', 'user_token=' . $this->session->data['user_token'], true);

		$data['back'] = $this->url->link('extension/productOrderSerialNumber/module/serial_number.findOrder', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/productOrderSerialNumber/module/apply_serial_numbers', $data));
	}

	public function processOrderSerialNumbers(): void
	{
		$this->load->language('extension/productOrderSerialNumber/module/serial_number');

		$json = [];

		if (!$this->user->hasPermission('modify', 'extension/productOrderSerialNumber/module/serial_number')) {
			$json['error']['warning'] = $this->language->get('error_permission');
		}

		if (isset($this->request->post['product_serial'])) {
			$product_serials = $this->request->post['product_serial'];

			foreach ($product_serials as $key => $serial) {
				$serials = explode("\n", $serial);
				$serials = array_filter(array_map('trim', $serials));
				$serials_count = count($serials);

				$product_quantity = $this->request->post['product_quantity'][$key];


				if ($serials_count != 0 && $serials_count != $product_quantity)
				$json['error']['warning'] = "Serial Numbers Should Match Order Quantity";
			}
			
		}
		
		if (!$json) {
			$this->load->model('extension/productOrderSerialNumber/module/serial_number');

			$product_serials = $this->request->post['product_serial'];
			$order_id = $this->request->post['order_id'];

			foreach ($product_serials as $order_product_id => $serials) {
				$product_name = $this->model_extension_productOrderSerialNumber_module_serial_number->getOrderProductName($order_product_id);

				$product_name = substr($product_name, 0, 150);
				$this->model_extension_productOrderSerialNumber_module_serial_number->restoreProductSerials($order_product_id, $order_id);

				$pro_serials = $this->model_extension_productOrderSerialNumber_module_serial_number->getProductSerialsByOrderProduct($order_product_id);

				$string = array();
				foreach ($pro_serials as $p_serial) {
					foreach ($p_serial as $value) {
						$string[] = $value;
					}
				}

				$serials = explode("\n", $serials);

				$serials = array_filter(array_map('trim', $serials));

				$warning_serials[$order_product_id] = [];

				foreach ($serials as $serial) {
					if (!empty($pro_serials)) {
						if (in_array($serial, $string)) {
							$this->model_extension_productOrderSerialNumber_module_serial_number->addOrderProductSerials($order_product_id, $serial, $found = 1);
							$this->model_extension_productOrderSerialNumber_module_serial_number->deleteProductSerialsByOrder($serial);
						} elseif (!in_array($serial, $string)) {
							$json['error']['warning-'.$order_product_id] = "Serials not matched but saved.";
							$this->model_extension_productOrderSerialNumber_module_serial_number->addOrderProductSerials($order_product_id, $serial, $found = 0);

							if (!in_array($serial, $warning_serials[$order_product_id])) {
								array_push($warning_serials[$order_product_id], $serial);
								$json['error']['warning-serials-'.$order_product_id] = "Mismatch serials: " . implode(", ", $warning_serials[$order_product_id]);

							}
						}
					} else {
						$this->model_extension_productOrderSerialNumber_module_serial_number->addOrderProductSerials($order_product_id, $serial, $found = 0);
					}

					$this->write('Product(' . $product_name . ') serial  "' . $serial . '" is assigned to Order# ' . $order_id);
				}
			}

			$json['success'] = 'Success: You have modified order product serial numbers';
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	private function getProductSerials($product_id)
	{

		$this->load->model('extension/productOrderSerialNumber/module/serial_number');

		$serials_string = array();

		$product_serials = $this->model_extension_productOrderSerialNumber_module_serial_number->getOrderProductSerials($product_id);

		if (!empty($product_serials)) {

			foreach ($product_serials as $product_serial) {

				array_push($serials_string, $product_serial['serial']);
			}

			return implode("\n", $serials_string);
		} else
			return '';
	}

	public function addProductSerials()
	{
		$this->load->language('extension/productOrderSerialNumber/module/serial_number');

		$this->document->setTitle($this->language->get('heading_title'));

		$data['breadcrumbs'] = [];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
		];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/productOrderSerialNumber/module/serial_number', 'user_token=' . $this->session->data['user_token'], true)
		];

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('add_serial_title'),
			'href' => $this->url->link('extension/productOrderSerialNumber/module/serial_number.addProductSerials&product_id='.$this->request->get['product_id'], 'user_token=' . $this->session->data['user_token'], true)
		);

		$this->load->model('catalog/product');
		$this->load->model('extension/productOrderSerialNumber/module/serial_number');

		//get product id
		if (isset($this->request->get['product_id'])) {

			$data['product_id'] = $this->request->get['product_id'];
		} else {

			$this->response->redirect($this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'], true));
		}

		$data['p_description'] = $this->model_catalog_product->getDescriptions($data['product_id']);
		$data['p_serial'] = $this->model_extension_productOrderSerialNumber_module_serial_number->getProductSerials($data['product_id']);

		if ($data['p_serial']) {
			$serial = $data['p_serial'];

			foreach ($serial as $value) {
				foreach ($value as $serial) {
					$serials[] = $serial;
				}
			}

			$serial = implode("\n", $serials);
			$data['product_serial'] = $serial;
		} else {
			$data['product_serial'] = '';
		}

		if (isset($data['p_description'][(int)$this->config->get('config_language_id')]))
			$data['p_description'] = array($data['p_description'][(int)$this->config->get('config_language_id')]);

		$data['user_token'] = $this->session->data['user_token'];

		$data['save'] = $this->url->link('extension/productOrderSerialNumber/module/serial_number.processProductSerialNumbers&user_token=' . $this->session->data['user_token'], true);

		$data['back'] = $this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/productOrderSerialNumber/module/product_serials', $data));
	}

	public function processProductSerialNumbers(): void
	{
		$this->load->language('extension/productOrderSerialNumber/module/serial_number');
		$this->load->model('extension/productOrderSerialNumber/module/serial_number');

		$json = [];

		if (!$this->user->hasPermission('modify', 'extension/productOrderSerialNumber/module/serial_number')) {
			$json['error']['warning'] = $this->language->get('error_permission');
		}

		if (!$json) {

			$product_id = $this->request->post['product_id'];

			$p_serial = $this->model_extension_productOrderSerialNumber_module_serial_number->getProductSerials($product_id);

			if ($p_serial) {
				$this->model_extension_productOrderSerialNumber_module_serial_number->deleteProductSerials($product_id);
			}

			$product_serial = $this->request->post['product_serial'];

			$product_serials = explode("\n", $product_serial);

			$product_serials = array_filter(array_map('trim', $product_serials));

			foreach ($product_serials as $serial) {

				$this->model_extension_productOrderSerialNumber_module_serial_number->addProductSerials($product_id, trim($serial));
			}

			$json['success'] = $this->language->get('text_success');
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	public function findOrderBySerial()
	{
		$this->load->language('extension/productOrderSerialNumber/module/serial_number');
		$this->load->language('sale/order');

		$this->document->setTitle($this->language->get('heading_title'));

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		if (isset($this->request->get['filter_order_serial'])) {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('find_order_by_serial_title'),
				'href' => $this->url->link('extension/productOrderSerialNumber/module/serial_number.findOrderBySerial&filter_order_serial='.$this->request->get['filter_order_serial'], 'user_token=' . $this->session->data['user_token'], true)
			);
		}else{
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('find_order_by_serial_title'),
				'href' => $this->url->link('extension/productOrderSerialNumber/module/serial_number.findOrderBySerial', 'user_token=' . $this->session->data['user_token'], true)
			);
		}

		if (isset($this->request->get['filter_order_serial'])) {
			$this->load->model('extension/productOrderSerialNumber/module/serial_number');

			$data['filter_order_serial'] = $this->request->get['filter_order_serial'];
			$data['orders'] = $this->model_extension_productOrderSerialNumber_module_serial_number->getOrdersByProductSerial($data['filter_order_serial']);

			if ($data['orders']) {
				$data['order_id'] = $data['orders'][0]['order_id'];

				$data['add_serial_url'] = $this->url->link('extension/productOrderSerialNumber/module/serial_number.applySerialNumbers&user_token=' . $this->session->data['user_token'], true);

				$data['order_view_url'] = $this->url->link('sale/order.info&user_token=' . $this->session->data['user_token'],'order_id=' . $data['order_id'], true);
			} else {
				$data['no_result'] = 'No result found';
			}
		} else {
			$data['filter_order_serial'] = '';
		}

		$data['restricted_view'] = false;

		$user_group_id = $this->user->getGroupId();

		if ($user_group_id == $this->config->get('module_serial_number_user_group')) {
			$this->request->get['filter_order_status_id'] = $this->config->get('module_serial_number_order_status');
			$data['restricted_view'] = true;
		}

		$data['save'] = $this->url->link('extension/productOrderSerialNumber/module/serial_number.findOrderBySerial', 'user_token=' . $this->session->data['user_token'], true);

		$data['back'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);
		
		$data['user_token'] = $this->session->data['user_token'];

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/productOrderSerialNumber/module/order_by_serial', $data));
	}

	public function exportCsv(): void
	{
		$this->load->model('extension/productOrderSerialNumber/module/serialNumber');

		$products = $this->model_extension_productOrderSerialNumber_module_serialNumber->getProductsWithSerials();

		if (!$products) {
			throw new Exception('No products found for export.');
		}

		header('Content-Type: text/csv; charset=utf-8');
		header('Content-Disposition: attachment; filename=product_serials.csv');

		$output = fopen('php://output', 'w');
		if ($output === false) {
			throw new Exception('Unable to open output stream.');
		}

		fputcsv($output, ['Product Id', 'Product Name', 'Serials'], ',', '"', '\\');

		foreach ($products as $product_id => $product) {
			fputcsv($output, [
				$product_id,
				$product['product_name'] ?? 'Unknown',
				isset($product['serials']) && is_array($product['serials']) 
					? implode(', ', $product['serials']) 
					: 'No serials'
			], ',', '"', '\\');
		}

		fclose($output);

		exit();
	}

	public function serialToMultipleProduct()
	{
		$this->load->language('extension/productOrderSerialNumber/module/serial_number');

		$this->document->setTitle($this->language->get('heading_title'));

		$data['breadcrumbs'] = [];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
		];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/productOrderSerialNumber/module/serial_number', 'user_token=' . $this->session->data['user_token'], true)
		];

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('add_serial_title'),
			'href' => $this->url->link('extension/productOrderSerialNumber/module/serial_number.serialToMultipleProduct', 'user_token=' . $this->session->data['user_token'], true)
		);

		$this->load->model('catalog/product');
		$this->load->model('extension/productOrderSerialNumber/module/serial_number');

		$data['user_token'] = $this->session->data['user_token'];

		$data['save'] = $this->url->link('extension/productOrderSerialNumber/module/serial_number.processMultipleProductSerialNumbers&user_token=' . $this->session->data['user_token'], true);

		$data['back'] = $this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');


		$this->response->setOutput($this->load->view('extension/productOrderSerialNumber/module/serial_multiple_product', $data));
	}

	public function processMultipleProductSerialNumbers(): void
	{
		$this->load->language('extension/productOrderSerialNumber/module/serial_number');
		$this->load->model('extension/productOrderSerialNumber/module/serial_number');

		$json = [];

		if (!$this->user->hasPermission('modify', 'extension/productOrderSerialNumber/module/serial_number')) {
			$json['error']['warning'] = $this->language->get('error_permission');
		}

		$products = $this->request->post['products'];
		$product_serial = $this->request->post['product_serial'];

		if($products == null){
			$json['error']['product'] = $this->language->get('error_products');
		}

		if($product_serial == null){
			$json['error']['serial'] = $this->language->get('error_serial');
		}

		if (!$json) {
			foreach($products as $product_id){
				$product_serials = explode("\n", $product_serial);
	
				$product_serials = array_filter(array_map('trim', $product_serials));
	
				foreach ($product_serials as $serial) {
					$this->model_extension_productOrderSerialNumber_module_serial_number->addProductSerials($product_id, trim($serial));
				}
			}
			
			$json['success'] = $this->language->get('text_success');
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
}